/* -LICENSE-START-
** Copyright (c) 2013 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/
//
//  SignalGenerator3DVideoFrame.cpp
//  Signal Generator
//


#include "stdafx.h"
#include "SignalGenerator3DVideoFrame.h"

#include <stdexcept>

#define CompareREFIID(iid1, iid2)	(memcmp(&iid1, &iid2, sizeof(REFIID)) == 0)

SignalGenerator3DVideoFrame::SignalGenerator3DVideoFrame(IDeckLinkMutableVideoFrame *left, IDeckLinkMutableVideoFrame *right) : m_frameLeft(left), m_frameRight(right), m_refCount(1)
{
	if (! m_frameLeft)
		throw std::invalid_argument("at minimum a left frame must be defined");

	m_frameLeft->AddRef();
	if (m_frameRight)
		m_frameRight->AddRef();
}

SignalGenerator3DVideoFrame::~SignalGenerator3DVideoFrame()
{
	m_frameLeft->Release();
	m_frameLeft = NULL;

	if (m_frameRight)
		m_frameRight->Release();
	m_frameRight = NULL;
}

HRESULT SignalGenerator3DVideoFrame::QueryInterface(REFIID iid, LPVOID *ppv)
{
	IID iunknown = IID_IUnknown;

	if (CompareREFIID(iid, iunknown))
		*ppv = static_cast<IDeckLinkVideoFrame*>(this);
	else if (CompareREFIID(iid, IID_IDeckLinkVideoFrame))
		*ppv = static_cast<IDeckLinkVideoFrame*>(this);
	else if (CompareREFIID(iid, IID_IDeckLinkVideoFrame3DExtensions))
		*ppv = static_cast<IDeckLinkVideoFrame3DExtensions*>(this);
	else
	{
		*ppv = NULL;
		return E_NOINTERFACE;
	}

	AddRef();
	return S_OK;
}

ULONG SignalGenerator3DVideoFrame::AddRef(void)
{
	return _InterlockedIncrement((volatile long *)&m_refCount);
}

ULONG SignalGenerator3DVideoFrame::Release(void)
{
	ULONG newRefValue = _InterlockedDecrement((volatile long*)&m_refCount);

	if (newRefValue == 0)
		delete this;
	return newRefValue;
}

long SignalGenerator3DVideoFrame::GetWidth(void)
{
	return m_frameLeft->GetWidth();
}

long SignalGenerator3DVideoFrame::GetHeight(void)
{
	return m_frameLeft->GetHeight();
}

long SignalGenerator3DVideoFrame::GetRowBytes(void)
{
	return m_frameLeft->GetRowBytes();
}

BMDPixelFormat SignalGenerator3DVideoFrame::GetPixelFormat(void)
{
	return m_frameLeft->GetPixelFormat();
}

BMDFrameFlags SignalGenerator3DVideoFrame::GetFlags(void)
{
	return m_frameLeft->GetFlags();
}

HRESULT SignalGenerator3DVideoFrame::GetBytes(/* out */ void **buffer)
{
	return m_frameLeft->GetBytes(buffer);
}

HRESULT SignalGenerator3DVideoFrame::GetTimecode(/* in */ BMDTimecodeFormat format, /* out */ IDeckLinkTimecode **timecode)
{
	return m_frameLeft->GetTimecode(format, timecode);
}

HRESULT SignalGenerator3DVideoFrame::GetAncillaryData(/* out */ IDeckLinkVideoFrameAncillary **ancillary)
{
	return m_frameLeft->GetAncillaryData(ancillary);
}

BMDVideo3DPackingFormat SignalGenerator3DVideoFrame::Get3DPackingFormat(void)
{
	return bmdVideo3DPackingLeftOnly;
}

HRESULT SignalGenerator3DVideoFrame::GetFrameForRightEye(/* out */ IDeckLinkVideoFrame* *rightEyeFrame)
{
	if (m_frameRight)
		return m_frameRight->QueryInterface(IID_IDeckLinkVideoFrame, (void**)rightEyeFrame);
	else
		return S_FALSE;
}
